#version 460 core

layout (triangles, fractional_odd_spacing, ccw) in;

uniform mat4 PVM;
uniform mat4 Model;

out vec2 FragTexCoords;

void main()
{
    vec4 Pos =  gl_TessCoord.x * gl_in[0].gl_Position +
                gl_TessCoord.y * gl_in[1].gl_Position +
                gl_TessCoord.z * gl_in[2].gl_Position;

    FragTexCoords = vec2(Pos) * 0.5f + 0.5f;
    gl_Position = PVM * Pos;
}
