#version 460 core

in vec2 FragTexCoords;

uniform sampler2D ImageTexture0;
uniform float Time;

out vec4 FragColor;

float density = 1.3;
float opacityScanline = .3;
float opacityNoise = .2;
float flickering = 0.03;

float Random(vec2 st)
{
    return fract(sin(dot(st.xy, vec2(12.9898, 78.233))) * 43758.5453123);
}

float blend(const in float x, const in float y)
{
    return (x < 0.5f) ? (2.0 * x * y) : (1.f - 2.f * (1.f - x) * 1.f - y);
}

vec3 blend(const in vec3 x, const in vec3 y, const in float opacity)
{
	vec3 z = vec3(blend(x.r, y.r), blend(x.g, y.g), blend(x.b, y.b));
	return z * opacity + x * (1.0 - opacity);
}

void main()
{
    vec3 col = texture(ImageTexture0, FragTexCoords).rgb;

    float count = 1080/density;

    vec2 uv = FragTexCoords;
    vec2 sl = vec2(sin(uv.y * count), cos(uv.y * count));
	vec3 scanlines = vec3(sl.x, sl.y, sl.x);

    col += col * scanlines * opacityScanline;
    col += col * vec3(Random(uv*Time)) * opacityNoise;
    col += col * sin(110.0*Time) * flickering;

    FragColor = vec4(col, 1.f);
}
