#version 460 core

in vec2 FragTexCoords;

uniform sampler2D ImageTexture0;
uniform float Time;

out vec4 FragColor;

void main()
{
    float amount = 0.f;

    amount = (1.0 + sin(Time*6.0)) * 0.5;
	amount *= 1.0 + sin(Time*16.0) * 0.5;
	amount *= 1.0 + sin(Time*19.0) * 0.5;
	amount *= 1.0 + sin(Time*27.0) * 0.5;
	amount = pow(amount, 3.0);

	amount *= 0.02;

    vec3 color;
    color.r = texture(ImageTexture0, vec2(FragTexCoords.x+amount,FragTexCoords.y) ).r;
    color.g = texture(ImageTexture0, FragTexCoords ).g;
    color.b = texture(ImageTexture0, vec2(FragTexCoords.x-amount,FragTexCoords.y) ).b;

    color *= (1.f - amount * 0.5f);
    FragColor = vec4(color, 1.f);
}
