#version 460 core

//in vec3 FragNormal;
in vec2 FragTexCoords;

// uniform inputs
uniform sampler2D ImageTexture0;
uniform float Offset = 0.f;

out vec4 FinalColor;

vec3 GetGradientColor(float t)
{
    float dt = 0.33f;
    float param;
    if (t < dt)
    {
        param = t / dt;
        //param = Offset / 0.33f;
        return mix(vec3(0,0,0), vec3(1,0,0), param); // black -> red
    }
    else if (t < (2.f * dt))
    {
        param = (t - dt) / dt;
        //param = (Offset - 0.33f) / 0.33f;
        return mix(vec3(1,0,0), vec3(1,1,0), param); // red -> yellow
    }
    else
    {
        param = (t - (2.f*dt)) / dt;
        //param = (Offset - 0.66f) / 0.33f;
        return mix(vec3(1,1,0), vec3(1,1,1), param); // yellow -> white
    }
}

void main()
{
    float t = texture(ImageTexture0, FragTexCoords).r;
	FinalColor = vec4(GetGradientColor(t), 1);
}
