#version 460 core

layout (triangles) in;
layout (triangle_strip, max_vertices = 3) out;

uniform mat4 PVM;
uniform float Parameter = 1f;

in VS_GS_VERTEX
{
	in vec4 Position;
	in vec3 Normal;
} vs_out[];

void main()
{
    float Length = 0.05f;
    
    //vec3 perp = cross(vec3(vs_out[0].Position - vs_out[1].Position), vec3(vs_out[2].Position - vs_out[1].Position));
    //vec3 aveNormal = normalize(perp);
    vec3 aveNormal = normalize(vs_out[0].Normal + vs_out[1].Normal + vs_out[2].Normal);

    for (int i = 0; i < 3; ++i)
    {
        gl_Position = vs_out[i].Position + PVM * vec4(aveNormal, 0.0f) * Length * Parameter;
        EmitVertex();
    }
    EndPrimitive();
}
