#version 460 core

uniform mat4 PVM;

//out vec2 FragTexCoords;
//in mat4 PVM;

out vec4 FragColor;

float near = 0.1f;
float far = 4.0f;
float LinearizeDepth(float depth)
{
	float z = depth * 2.0f - 1.0f; // back to NDC
	return (2.0f * near * far) / (far + near - z * (far - near));
}

void main()
{
    float depth = LinearizeDepth(gl_FragCoord.z) / far; // divide by far for demonstartion
    FragColor = PVM * vec4(vec3(depth), 1.0);
}