#version 460 core

layout (location = 0) out vec4 Texture_Position;
layout (location = 1) out vec4 Texture_Normal;
layout (location = 2) out vec4 Texture_AlbedoSpec;

in vec2 FragTexCoords;
in vec3 FragNormal;
in vec3 FragPos;

uniform sampler2D ImageTexture0;
uniform float SpecularStr = 1.f;

out vec4 FinalColor;

void main()
{
    Texture_Position = vec4(FragPos, 1.f);
    Texture_Normal = vec4(normalize(FragNormal), 1.f);
    Texture_AlbedoSpec.rgb = texture(ImageTexture0, FragTexCoords).rgb;
    Texture_AlbedoSpec.a = SpecularStr;
}
