#version 460 core

in vec2 FragTexCoords;
in vec3 FragNormal;
in vec3 FragPos;

// uniform inputs
uniform sampler2D ImageTexture0;
uniform vec3 CameraPos;
uniform float AmbientStrength		= 0.05f;
uniform vec3 AmbientColor			= vec3(1.0f, 1.0f, 1.0f);
uniform vec3 LightColor				= vec3(1.f, 1.f, 1.f);
uniform vec3 LightPos				= vec3(12.0f, 16.0f, 20.f);
uniform float LightSpecularStrength	= 1.0f;
uniform float Shininess				= 5.f;

out vec4 FinalColor;

void main()
{
	// Light direction
	vec3 Normal = normalize(FragNormal);
	vec3 LightDir = normalize(FragPos - LightPos);

	// Ambient component
	vec3 Ambient = AmbientStrength * AmbientColor;

	// Diffuse component
	float DiffuseStrength = max(dot(Normal, -LightDir), 0.0f);
	vec3 Diffuse = DiffuseStrength * LightColor;

	// Specular component
	vec3 ReverseViewDir = -normalize(CameraPos - FragPos);
	vec3 ReflectedDir	= reflect(LightDir, Normal);
	float SpecularReflectivity = pow(max(dot(ReverseViewDir, ReflectedDir), 0.f), Shininess);
	vec3 Specular = LightSpecularStrength * SpecularReflectivity * LightColor;

	//Combine lighting components
	vec4 Light = vec4(Ambient + Diffuse + Specular, 1.0f);

	//Calculate final color
	FinalColor = Light * texture(ImageTexture0, FragTexCoords);
}
